#include "MeshLoader.h"
#include "NeuMeshLoader.h"
#include "AneuMeshLoader.h"
#include "FileOpenExceptions.h"

#include <iostream>
#include <string>
#include <fstream>
#include <algorithm>

MeshLoader* CheckFormatFile(const std::string& _f) { 
    std::string file(_f);
    while (file.back() == ' ')
        file.pop_back();
    MeshLoader* mesh_pointer = nullptr;

    std::size_t found = file.rfind(".aneu");
    if (found != std::string::npos && file.length() - found == 5) 
    {
        std::cout << "Suitable file format." << std::endl;

        mesh_pointer = new AneuMeshLoader;

        return mesh_pointer;
    }

    found = file.rfind(".neu");
    if (found != std::string::npos && file.length() - found == 4) {
        std::cout << "Suitable file format." << std::endl;
        dynamic_cast<NeuMeshLoader*>(mesh_pointer);
        mesh_pointer = new NeuMeshLoader;
        return mesh_pointer;
    }

    else {
        std::cout << "Unsuitable file format" << std::endl;
        std::size_t dot = file.rfind('.');
        if (dot == std::string::npos)
            throw BadFileFormatException();
        else throw BadFileFormatException(file.substr(file.rfind('.'), file.size() - file.rfind('.')));
    };
}

void LoadMesh(MeshLoader* loader_, const std::string& filepath_) 
{
    loader_->LoadMesh(filepath_);
    loader_->Print_Data();
    std::vector<FiniteElement> elements_vector;
    std::vector<Node> nodes_vector;
    std::vector<std::set<int>> neighbors;
    std::vector<BoundaryFiniteElement> surfaces_vector;

    std::cout << "Result of Get_Elements_by_ID(1, 2, 3) function:\n";
    elements_vector = loader_->Get_Elements_by_ID(1, 2, 3);
    std::cout << elements_vector;
    elements_vector.clear();

    std::cout << "\nResult of Get_Elements_by_edge(2, 4) function:\n";
    elements_vector = loader_->Get_Elements_by_rib(2, 4);
    std::cout << elements_vector;
    elements_vector.clear();

    std::cout << "\nResult of Get_Vertex_Nodes_by_Border_ID(3) function:\n";
    nodes_vector = loader_->Get_Vertex_Nodes_by_Border_ID(3);
    std::cout << nodes_vector;
    nodes_vector.clear();

    std::cout << "\nResult of Get_Elements_by_ID_area(1) function:\n";
    elements_vector = loader_->Get_Elements_by_ID_area(1);
    std::cout << elements_vector;
    elements_vector.clear();

    std::cout << "\nResult of Get_Borders_by_Border_ID(1) function:\n";
    surfaces_vector = loader_->Get_Borders_by_Border_ID(1);
    std::cout << surfaces_vector;
    surfaces_vector.clear();

    std::cout << "\nResult of Get_Nodes_Neighbors() function:\n";
    neighbors = loader_->Get_Nodes_Neighbors();
    for (int i = 0; i < neighbors.size(); ++i)
    {
        std::cout << "Neighbors for Node with ID = " << i + 1 << "\n" <<
            neighbors[i].size() << (neighbors[i].size() > 1 ? " Nodes:\n" : " Node:\n") << " ID" <<
            std::setw(10) << "X" << std::setw(11) << "Y" << std::setw(11) << "Z" << std::setw(14) << "Vertex\n";
        for (const auto& it : neighbors[i])
            std::cout << loader_->Get_Node_by_ID(it);
    }
    neighbors.clear();

    std::cout << "\nResult of Insert_New_Nodes() function:\n";
    loader_->Insert_New_Nodes();
    loader_->Print_Data();
}



int main(int argc, char* argv[]) {

    std::string filepath = "MeshExample.aneu";
    MeshLoader* loader = CheckFormatFile(filepath);
    LoadMesh(loader, filepath);

    delete loader;
    return 0;
}
