#pragma once
#include <iostream>
#include <iomanip>
#include <vector>
#include <set>

struct Node 
{
    int id;
    double x, y, z;
    bool vertex;

    Node() = default;

    Node(int ID_, double x_, double y_, double z_, bool vertex_) : 
        id(ID_), 
        x(x_), 
        y(y_), 
        z(z_), 
        vertex(vertex_) 
    {}

    bool operator==(const Node& right_node) const 
    {
        if (id == right_node.id && x == right_node.x && y == right_node.y &&
            z == right_node.z && vertex == right_node.vertex)
            return true;
        else return false;
    }

    bool operator<(const Node& right_node) const 
    {
        return id < right_node.id;
    }


    friend std::ostream& operator<<(std::ostream& out_stream, const Node& node_)
    {
        out_stream << std::setw(4) << node_.id << " |"
            << std::right << std::setw(11) << node_.x << std::setw(11) << node_.y << std::setw(11) << node_.z
            << " | " << node_.vertex << "\n";
        return out_stream;
    }

    friend std::ostream& operator<<(std::ostream& out_stream, const std::vector<Node>& nodes_) 
    {
        out_stream << nodes_.size() << (nodes_.size() > 1 ? " Nodes:\n" : " Node:\n") << " ID"
            << std::setw(10) << "X" << std::setw(11) << "Y" << std::setw(11) << "Z" << std::setw(14) << "Vertex\n";
        for (const auto& it : nodes_)
            out_stream << it;
        return out_stream;
    }

};

struct FiniteElement {
    int element_id;
    int material_id;
    std::vector<int> nodes_id;

    friend std::ostream& operator<<(std::ostream& out_stream, const FiniteElement& element_) 
    {
        out_stream << std::setw(4) << element_.element_id << " |"
            << std::setw(11) << element_.material_id << " |";
        for (const auto& nodes_ID_it : element_.nodes_id)
            out_stream << std::right << std::setw(4) << nodes_ID_it;
        out_stream << "\n";
        return out_stream;
    }

    friend std::ostream& operator<<(std::ostream& out_stream, const std::vector<FiniteElement>& elements_)
    {
        int elements_size = elements_.size();
        out_stream << elements_size << (elements_size > 1 ? " FiniteElement:\n" : " FiniteElement:\n")
            << " ID" << std::setw(15) << "Material_ID" << std::setw(15) << "Nodes ID\n";
        for (const auto& it : elements_)
            out_stream << it;
        return out_stream;
    }
};

struct BoundaryFiniteElement {
    int element_id;
    int border_id;
    std::vector<int> nodes_id;

    friend std::ostream& operator<<(std::ostream& out_stream, const BoundaryFiniteElement& surface_) 
    {
        out_stream << std::setw(9) << surface_.element_id << " |"
            << std::setw(9) << surface_.border_id << " |";
        for (const auto& nodes_ID_it : surface_.nodes_id)
            out_stream << std::right << std::setw(4) << nodes_ID_it;
        out_stream << "\n";
        return out_stream;
    }

    friend std::ostream& operator<<(std::ostream& out_stream, const std::vector<BoundaryFiniteElement>& surfaces_) 
    {
        int surfaces_size = surfaces_.size();
        out_stream << surfaces_size << (surfaces_size > 1 ? " BoundaryFiniteElement:\n" : " BoundaryFiniteElement:\n")
            << "Boundary_ID" << std::setw(11) << "Border_ID" << std::setw(11) << "Nodes ID\n";
        for (const auto& it : surfaces_)
            out_stream << it;
        return out_stream;
    }

};

struct Edge {
    int head_id;
    int last_id;
    int self_id;

    Edge() = default;

    Edge(int h_id, int l_id) :
        head_id(h_id),
        last_id(l_id)
    {}


    bool operator == (const Edge& sec_odj) const
    {
        return (head_id == sec_odj.head_id && last_id == sec_odj.last_id) ||
            (last_id == sec_odj.head_id && head_id == sec_odj.last_id);
    }

};

class EdgeHash {
public:
    std::size_t operator() (const Edge& _p) const
    {
        std::size_t o_seed = 0;
        if (_p.head_id > _p.last_id)
        {
            o_seed ^= std::hash<int>() (_p.head_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
            o_seed ^= std::hash<int>() (_p.last_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
        }
        else
        {
            o_seed ^= std::hash<int>() (_p.last_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
            o_seed ^= std::hash<int>() (_p.head_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
        }

        return o_seed;
    }

};

