#pragma once
#include "MeshLoader.h"
#include "HelperTypes.h"
#include "FileOpenExceptions.h"

#include <fstream>
#include <iostream>


class AneuMeshLoader : public MeshLoader 
{
public:
    void LoadMesh(const std::string& filename) override
    {
        std::ifstream fin(filename);
        if (!fin) 
            throw NoFileFoundException(filename);

        else std::cout << "File \"" << filename << "\" was opened successfully." << std::endl;

        int amount, dimension;

        fin >> amount >> dimension;
        nodes.reserve(amount);
        for (int i = 1; i <= amount; ++i) 
        {
            Node temp_node;
            temp_node.id = i;
            fin >> temp_node.x >> temp_node.y >> temp_node.z;
            temp_node.vertex = true;
            nodes.push_back(temp_node);
        }

        fin >> amount >> dimension;
        elements.reserve(amount);
        for (int i = 1; i <= amount; ++i) 
        {
            FiniteElement temp_element;
            temp_element.element_id = i;
            fin >> temp_element.material_id;
            temp_element.nodes_id.reserve(dimension);
            int temp_id;
            for (int j = 0; j < dimension; ++j) 
            {
                fin >> temp_id;
                temp_element.nodes_id.push_back(temp_id);
            }
            elements.push_back(temp_element);
        }

        fin >> amount >> dimension;
        boundary.reserve(amount);
        for (int i = 1; i <= amount; ++i) 
        {
            BoundaryFiniteElement temp_surface;
            temp_surface.element_id = i;
            fin >> temp_surface.border_id;
            temp_surface.nodes_id.reserve(dimension);
            int temp_id;
            for (int j = 0; j < dimension; ++j) 
            {
                fin >> temp_id;
                temp_surface.nodes_id.push_back(temp_id);
            }
            boundary.push_back(temp_surface);
        }

        fin.close();
        std::cout << "All data was loaded, closing the file..." << std::endl;
    }

};

