#pragma once
#include "MeshDatatypes.h"  
template <class T>
inline void hash_combine(std::size_t& seed, const T& v)
{
	std::hash<T> hasher;
	seed ^= hasher(v) + 0x9e3779b9 + (seed << 6) + (seed >> 2);
}

template < typename _T >
inline void hashVal(std::size_t& o_seed, const _T& p_val)
{
	hash_combine(o_seed, p_val);
}

template < typename _T, typename ... _Types >
inline void hashVal(std::size_t& o_seed, const _T& p_val, const _Types& ... p_args)
{
	hash_combine(o_seed, p_val);
	hashVal(o_seed, p_args ...);
}

template < typename ... _Types >
inline std::size_t hashVal(const _Types&... p_args)
{
	std::size_t seed = 0;
	hashVal(seed, p_args ...);
	return seed;
}


class edge_pair_hash {
public:
	std::size_t operator () (const std::pair<uint16_t, uint16_t>& p_pair) const {
	    
	    // теперь числа упорядочены
		if (p_pair.first <= p_pair.second)
		{
			return hashVal(p_pair.first, p_pair.second); 
		}
		else
		{
			return hashVal(p_pair.second, p_pair.first);
		}
	}
};


class findFiniteElementBy3Nodes {
public:
	findFiniteElementBy3Nodes(uint16_t p_id1, uint16_t p_id2, uint16_t p_id3) : id1(p_id1),id2(p_id2),id3(p_id3) {}
	bool operator () (std::pair<uint16_t,FiniteElement> currentFiniteElement) {
		return std::find(currentFiniteElement.second.nodes.begin(), currentFiniteElement.second.nodes.end(), id1) != currentFiniteElement.second.nodes.end()
			&& std::find(currentFiniteElement.second.nodes.begin(), currentFiniteElement.second.nodes.end(), id2) != currentFiniteElement.second.nodes.end()
			&& std::find(currentFiniteElement.second.nodes.begin(), currentFiniteElement.second.nodes.end(), id3) != currentFiniteElement.second.nodes.end();
	}
private:
	uint16_t id1;
	uint16_t id2;
	uint16_t id3;
};


class findFiniteElementByEdge {
public:
	findFiniteElementByEdge(uint16_t p_id1, uint16_t p_id2) : id1(p_id1), id2(p_id2) {}
	bool operator () (std::pair<uint16_t, FiniteElement> currentFiniteElement) {
		return std::find(currentFiniteElement.second.nodes.begin(), currentFiniteElement.second.nodes.end(), id1) != currentFiniteElement.second.nodes.end()
			&& std::find(currentFiniteElement.second.nodes.begin(), currentFiniteElement.second.nodes.end(), id2) != currentFiniteElement.second.nodes.end();
	}
private:
	uint16_t id1;
	uint16_t id2;
};


class findBoundaryFiniteElementByEdge {
public:
	findBoundaryFiniteElementByEdge(uint16_t p_id1, uint16_t p_id2) : id1(p_id1), id2(p_id2) {}
	bool operator () (std::pair<uint16_t, BoundaryFiniteElement> currentBFiniteElement) {
		return std::find(currentBFiniteElement.second.nodes.begin(), currentBFiniteElement.second.nodes.end(), id1) != currentBFiniteElement.second.nodes.end()
			&& std::find(currentBFiniteElement.second.nodes.begin(), currentBFiniteElement.second.nodes.end(), id2) != currentBFiniteElement.second.nodes.end();
	}
private:
	uint16_t id1;
	uint16_t id2;
};


class findBoundaryBySurfaceID {
public:
	findBoundaryBySurfaceID(uint16_t p_surID) : surID(p_surID) {}
	bool operator () (std::pair<uint16_t, BoundaryFiniteElement> currentBoundary) {
		return currentBoundary.second.surfaceId == surID;
	}
private:
	uint16_t surID;
};


class findFiniteElementByNode {
public:
	findFiniteElementByNode(uint16_t p_id1) : id1(p_id1) {}
	bool operator () (std::pair<uint16_t, FiniteElement> currentFiniteElement) {
		return std::find(currentFiniteElement.second.nodes.begin(), currentFiniteElement.second.nodes.end(), id1) != currentFiniteElement.second.nodes.end();
	}
private:
	uint16_t id1;
};


class findFiniteElementByMaterialID {
public:
	findFiniteElementByMaterialID(uint16_t p_areaID) : areaID(p_areaID) {}
	bool operator () (std::pair<uint16_t, FiniteElement> currentFinite) {
		return currentFinite.second.materialId == areaID;
	}
private:
	uint16_t areaID;
};


class ifFEContainNodes
{
private:

	std::vector<uint16_t> c_nodes_ids;
public:

	ifFEContainNodes(std::vector<uint16_t>& p_n_v) :
		c_nodes_ids(p_n_v)
	{}

	ifFEContainNodes(const std::vector<uint16_t>& p_n_v) :
		c_nodes_ids(p_n_v)
	{}

	bool operator () (const std::pair<uint16_t, FiniteElement>& p_fe)
	{
		std::vector<uint16_t>::iterator p_nodes_iter = c_nodes_ids.begin();
		auto p_fe_node_id_iterator = p_fe.second.nodes.cbegin();
		bool is_one = true;
		while (is_one && p_nodes_iter != c_nodes_ids.end())
		{
			is_one = false;
			while ((p_fe_node_id_iterator != p_fe.second.nodes.cend()) && !is_one)
			{
				if (*p_fe_node_id_iterator == *p_nodes_iter)
				{
					is_one = true;
				}
				p_fe_node_id_iterator++;
			}
			p_nodes_iter++;
			p_fe_node_id_iterator = p_fe.second.nodes.cbegin();
		}

		return is_one;
	}
};
