#pragma once

#include <stdint.h>
#include <vector>


struct Node {
	uint16_t ID;
	std::vector<double> coords;

	Node() {}

	Node(uint16_t p_ID, const std::vector<double> &p_coords) : ID(p_ID) { // p_const with const link 
		coords = std::move(p_coords);
	}
};

struct FiniteElement {
	uint16_t ID;
	uint16_t materialId;
	std::vector<uint16_t> nodes;

    //p_nodes with const link
	FiniteElement(uint16_t p_ID, uint16_t p_materialId, const std::vector<uint16_t> &p_nodes) : ID(p_ID), materialId(p_materialId) {
		nodes = std::move(p_nodes);
	}
	

	bool operator == (const FiniteElement& to_cmp) const
	{
		return to_cmp.ID == ID && to_cmp.materialId == materialId && to_cmp.nodes == nodes;
	}
};

struct BoundaryFiniteElement {
	uint16_t ID;
	uint16_t surfaceId;
	std::vector<uint16_t> nodes;

    //p_nodes with const link
	BoundaryFiniteElement(uint16_t p_ID, uint16_t p_surfaceId, const std::vector<uint16_t> &p_nodes) : ID(p_ID), surfaceId(p_surfaceId) {
		nodes = std::move(p_nodes);
	}

	std::vector<uint16_t> getNodes()
	{
		return nodes;
	}

	bool operator == (const BoundaryFiniteElement& to_cmp) const
	{
		return to_cmp.ID == ID && to_cmp.surfaceId == surfaceId && to_cmp.nodes == nodes;
	}
};