#include "AneuMeshLoader.h"
#include "Exceptions.h"
#include <fstream>
#include <iostream>
#include <algorithm>



AneuMeshLoader::AneuMeshLoader() : MeshLoader() {}

AneuMeshLoader::AneuMeshLoader(const std::string& p_fileName) : MeshLoader(p_fileName) {}

AneuMeshLoader::~AneuMeshLoader() {}

void AneuMeshLoader::load() {
	std::ifstream meshStream;
	meshStream.open(fileName);
	try {
		if (!meshStream)
		{
			throw(new FileNotFoundExc ("No such file! Maybe it does not exist or not in this directory."));
		}
		else
		{
			std::cout << "File successfully opened, mesh is read!" << std::endl << std::endl;

			int p_nodesCount;
			meshStream >> p_nodesCount;
			nodesCount = p_nodesCount;
			int dimensionality;
			meshStream >> dimensionality;

			std::cout << "Mesh has " << nodesCount << " nodes." << std::endl;
			std::cout << "Every node has " << dimensionality << " dots. Dimensionality of this space is " << dimensionality << std::endl << std::endl;

			for (int i = 0; i < nodesCount; i++) {
				std::vector<double> coords;
				coords.reserve(dimensionality);

				for (int j = 0; j < dimensionality; j++) {
					double temp;
					meshStream >> temp;
					coords.push_back(temp);
				}
				Node newNode(i + 1, coords);
				nodes.push_back(newNode);
			}
			nodes.shrink_to_fit();

			int finCount;
			meshStream >> finCount;
			std::cout << std::endl << "Mesh has " << finCount << " finite elements." << std::endl;
			int nodesInFE;
			meshStream >> nodesInFE;
			std::cout << "Every FE has " << nodesInFE << " nodes." << std::endl << std::endl;

			for (int i = 0; i < finCount; i++) {
				uint16_t matId;
				meshStream >> matId;

				std::vector<uint16_t> p_nodes;
				p_nodes.reserve(nodesInFE);

				for (int j = 0; j < nodesInFE; j++) {
					int temp;
					meshStream >> temp;
					p_nodes.push_back(temp);
				}

				finiteElements.emplace(i + 1, FiniteElement(i + 1, matId, p_nodes));
			}

			int boundFinElCount;
			meshStream >> boundFinElCount;
			int dotsInBoundFinEl;
			meshStream >> dotsInBoundFinEl;

			std::cout << "Mesh has " << boundFinElCount << " boundary finiute elements." << std::endl << "Every BFE has " << dotsInBoundFinEl << " dots." << std::endl << std::endl;

			for (int i = 0; i < boundFinElCount; i++) {
				uint16_t surId;
				meshStream >> surId;

				std::vector<uint16_t> p_nodes;
				p_nodes.reserve(dotsInBoundFinEl);

				for (int j = 0; j < dotsInBoundFinEl; j++) {
					int temp;
					meshStream >> temp;
					p_nodes.push_back(temp);
				}

				boundaryFiniteElements.emplace(std::make_pair(i + 1, BoundaryFiniteElement(i + 1, surId, p_nodes)));
			}

			std::for_each(boundaryFiniteElements.begin(), boundaryFiniteElements.end(), [&dotsInBoundFinEl, this](const std::pair<uint16_t, BoundaryFiniteElement>& bfe) {
				for (int i = 0; i < dotsInBoundFinEl; i++) {
					for (int j = i; j < dotsInBoundFinEl; j++) {
						boundaryEdges.insert(std::make_pair(bfe.second.nodes.at(i), bfe.second.nodes.at(j)));
					}
				}
				}
			);
			
			std::for_each(finiteElements.begin(), finiteElements.end(), [&nodesInFE, this](const std::pair<uint16_t, FiniteElement>& fe) {
				for (int i = 0; i < nodesInFE; i++) {
					for (int j = i; j < nodesInFE; j++) {
						allEdges.insert(std::make_pair(fe.second.nodes.at(i), fe.second.nodes.at(j)));
					}
				}
				}
			);
		}
	}
	catch (FileNotFoundExc ex) {
		std::cout << "ERROR!: " << ex.what() << std::endl;
	}
	meshStream.close();
}
