#pragma once

#include "MeshDatatypes.h"
#include "Predicates.h"
#include <string>
#include <vector>
#include <map>
#include <set>
#include <iterator>
#include <unordered_map>
#include <unordered_set>

class MeshLoader {
public:
	MeshLoader();
	MeshLoader(const std::string& p_fileName);
	
	virtual ~MeshLoader(); // virtual destructor 
		
	virtual void load() = 0;

	void printNodes();
	void printFiniteElems();
	void printBoundaryFiniteElements();

	void  find_pos_by_2_ids_and_FEdims(const std::pair<size_t, size_t>& p_pair, const size_t& p_FEdimensions, std::unordered_map<uint16_t, FiniteElement>::iterator finEl, std::uint16_t p_p);
	void  find_pos_by_2_ids_and_FEdims(const std::pair<size_t, size_t>& p_pair, const size_t& p_FEdimensions, std::unordered_map<uint16_t, BoundaryFiniteElement>::iterator BfinEl, std::uint16_t p_p);

	const std::vector<Node>& getNodes();
	const std::unordered_map<uint16_t, FiniteElement>& getFiniteElems();
	const std::unordered_map<uint16_t, BoundaryFiniteElement>& getBoundaryFiniteElements();

	std::vector<FiniteElement> getFEbyNodesIds(uint16_t id1, uint16_t id2, uint16_t id3);
	std::vector<std::unordered_map<uint16_t, FiniteElement>::iterator> getFEbyEdge(uint16_t id1, uint16_t id2);

	std::vector<BoundaryFiniteElement> getBFEbySurfaceID(uint16_t surID);
	std::vector<std::unordered_map<uint16_t, BoundaryFiniteElement>::iterator> getBFEbyEdge(uint16_t id1, uint16_t id2);

	std::vector<Node> getNodesbySurfaceID(uint16_t surID);
	std::vector<FiniteElement> getFEbyMaterialID(uint16_t areaID);

	std::vector<std::set<uint16_t>> nodeNeighbours();

	bool insertMiddlesOfEdges();


protected:
	std::string fileName;


	std::vector<Node> nodes;                    
	std::unordered_map<uint16_t, FiniteElement> finiteElements;               
	std::unordered_map<uint16_t, BoundaryFiniteElement> boundaryFiniteElements;    
	std::unordered_set<std::pair<uint16_t, uint16_t>, edge_pair_hash> alreadyHasMiddle;
	std::unordered_set<std::pair<uint16_t, uint16_t>, edge_pair_hash> allEdges;
	std::unordered_set<std::pair<uint16_t, uint16_t>, edge_pair_hash> boundaryEdges;

	unsigned nodesCount;
};