#include <iostream>
#include <iomanip>
#include <algorithm>
#include "MeshLoader.h"
#include "Predicates.h"

MeshLoader::MeshLoader() : fileName("") {};

MeshLoader::MeshLoader(const std::string& p_fileName) : fileName(p_fileName) {};

MeshLoader::~MeshLoader()
{}; 

void MeshLoader::printNodes()
{
	
	std::for_each(nodes.begin(), nodes.end(), [](const Node& node) {
		std::cout << "ID: " << std::setw(4) << node.ID << "| ";
		std::cout << std::fixed << std::setprecision(6);

		std::for_each(node.coords.begin(), node.coords.end(), [](const auto& coord) {
			std::cout << std::setw(10) << coord;
			});
		std::cout << std::endl; 
	});
}

void MeshLoader::printFiniteElems()
{
	std::for_each(finiteElements.begin(), finiteElements.end(), [](const auto& fe) {
		std::cout << "ID: " << std::setw(4) << fe.second.ID << "| Material ID: " << std::setw(3)
			<< fe.second.materialId << "| " << "Nodes ID's: ";
		std::for_each(fe.second.nodes.begin(), fe.second.nodes.end(), [](const auto& id) {
			std::cout << std::setw(4) << id;
			});
		std::cout << std::endl;
	});
}

void MeshLoader::printBoundaryFiniteElements()
{
	std::for_each(boundaryFiniteElements.begin(), boundaryFiniteElements.end(), [](const auto& bfe) {
		std::cout << "ID: " << std::setw(4) << bfe.second.ID << "| Surface ID: " << std::setw(3)
			<< bfe.second.surfaceId << "| " << "Nodes ID's: ";

		std::for_each(bfe.second.nodes.begin(), bfe.second.nodes.end(), [](auto& nodeIds) {
			std::cout << " " << std::setw(4) << nodeIds;
		});
		std::cout << std::endl;
		}
	);
}

/*//в итоге метод не используется
void MeshLoader::find_pos_by_2_ids_and_FEdims(
    const std::pair<size_t , size_t>                      &p_pair,
    const size_t&                                          p_FEdimensions, 
    std::unordered_map<uint16_t, FiniteElement>::iterator  finEl, 
    std::uint16_t                                          p_p)
{
	
	size_t p_id_1; 
	size_t p_id_2; 

	for (size_t at_id = 0; at_id < p_FEdimensions; at_id++)
	{
		if (finEl->second.nodes.at(at_id) == p_pair.first)
			{
				p_id_1 = at_id;
			}
			if (finEl->second.nodes.at(at_id) == p_pair.second)
			{
				p_id_2 = at_id;
			}
		}

	if (p_id_1 > p_id_2)
	{
		std::swap<size_t>(p_id_1, p_id_2);
	}

	unsigned int res_pos = p_FEdimensions;

	res_pos += (2 * p_FEdimensions - p_id_1 - 1) * p_id_1 / 2;

	res_pos += p_id_2 - (p_id_1 + 1);
	
	finEl->second.nodes.at(res_pos)=p_p; 
}

void MeshLoader::find_pos_by_2_ids_and_FEdims(const std::pair<size_t, size_t>& p_pair, const size_t& p_FEdimensions, std::unordered_map<uint16_t, BoundaryFiniteElement>::iterator BfinEl, std::uint16_t p_p)
{

	size_t p_id_1;
	size_t p_id_2;

	for (size_t at_id = 0; at_id < p_FEdimensions; at_id++)
	{
		if (BfinEl->second.nodes.at(at_id) == p_pair.first)
		{
			p_id_1 = at_id;
		}
		if (BfinEl->second.nodes.at(at_id) == p_pair.second)
		{
			p_id_2 = at_id;
		}
	}

	if (p_id_1 > p_id_2)
	{
		std::swap<size_t>(p_id_1, p_id_2);
	}

	unsigned int res_pos = p_FEdimensions;

	res_pos += (2 * p_FEdimensions - p_id_1 - 1) * p_id_1 / 2;

	res_pos += p_id_2 - (p_id_1 + 1);
	
	BfinEl->second.nodes.at(res_pos) = p_p;
} */ 

const std::vector<Node>& MeshLoader::getNodes()
{
	return nodes;
}

const std::unordered_map<uint16_t, FiniteElement>& MeshLoader::getFiniteElems()
{
	return finiteElements;
}

const std::unordered_map<uint16_t, BoundaryFiniteElement>& MeshLoader::getBoundaryFiniteElements()
{ 
	return boundaryFiniteElements;
}

std::vector<FiniteElement> MeshLoader::getFEbyNodesIds(uint16_t id1, uint16_t id2, uint16_t id3)
{
	std::vector<FiniteElement> answer;
	auto currentIter = finiteElements.begin();
	auto endIter = finiteElements.end();
	while (currentIter != endIter) {
		findFiniteElementBy3Nodes finder(id1,id2,id3);
		currentIter = std::find_if(currentIter, endIter, finder);
		if (currentIter != endIter) {
			answer.push_back((*currentIter).second);
			++currentIter;
		}
	}
	answer.shrink_to_fit();
	return answer;
}

std::vector<std::unordered_map<uint16_t, FiniteElement>::iterator> MeshLoader::getFEbyEdge(uint16_t id1, uint16_t id2)
{
	std::vector<std::unordered_map<uint16_t, FiniteElement>::iterator> answer;
	auto currentIter = finiteElements.begin();
	auto endIter = finiteElements.end();
	while (currentIter != endIter) {
		findFiniteElementByEdge finder(id1, id2);
		currentIter = std::find_if(currentIter, endIter, finder);
		if (currentIter != endIter) {
			answer.push_back(currentIter);
			++currentIter;
		}
	}
	answer.shrink_to_fit();
	return answer;
}

std::vector<BoundaryFiniteElement> MeshLoader::getBFEbySurfaceID(uint16_t surID)
{
	std::vector<BoundaryFiniteElement> answer;
	auto currentIter = boundaryFiniteElements.begin();
	auto endIter = boundaryFiniteElements.end();
	while (currentIter != endIter) {
		findBoundaryBySurfaceID finder(surID);
		currentIter = std::find_if(currentIter, endIter, finder);
		if (currentIter != endIter) {
			answer.push_back((*currentIter).second);
			++currentIter;
		}
	}
	answer.shrink_to_fit();
	return answer;
}

std::vector<std::unordered_map<uint16_t, BoundaryFiniteElement>::iterator> MeshLoader::getBFEbyEdge(uint16_t id1, uint16_t id2)
{
	std::vector<std::unordered_map<uint16_t, BoundaryFiniteElement>::iterator> answer;
	auto currentIter = boundaryFiniteElements.begin();
	auto endIter = boundaryFiniteElements.end();
	while (currentIter != endIter) {
		findBoundaryFiniteElementByEdge finder(id1, id2);
		currentIter = std::find_if(currentIter, endIter, finder);
		if (currentIter != endIter) {
			answer.push_back(currentIter);
			++currentIter;
		}
	}
	answer.shrink_to_fit();
	return answer;
}

std::vector<Node> MeshLoader::getNodesbySurfaceID (uint16_t surID)
{
	std::vector<Node> answer;
	std::vector<BoundaryFiniteElement> temp = this->getBFEbySurfaceID(surID);
	auto currentIter = temp.begin();
	auto endIter = temp.end();
	while (currentIter != endIter) {
		answer.push_back(nodes.at((currentIter->nodes.at(0)) - 1));
		answer.push_back(nodes.at((currentIter->nodes.at(1)) - 1));
		answer.push_back(nodes.at((currentIter->nodes.at(2)) - 1));
		++currentIter;
	}
	std::sort(answer.begin(), answer.end(), [](const Node& p_node_1, const Node& p_node_2) { return p_node_1.ID < p_node_2.ID; });
	answer.erase(std::unique(answer.begin(), answer.end(), [](const Node& p_node_1, const Node& p_node_2) { return p_node_1.ID == p_node_2.ID; }), answer.end());
	answer.shrink_to_fit();
	return answer;
}

std::vector<FiniteElement> MeshLoader::getFEbyMaterialID(uint16_t areaID)
{
	std::vector<FiniteElement> answer;
	auto currentIter = finiteElements.begin();
	auto endIter = finiteElements.end();
	while (currentIter != endIter)
	{
		findFiniteElementByMaterialID finder(areaID);
		currentIter = std::find_if(currentIter, endIter, finder);
		if (currentIter != endIter) {
			answer.push_back((*currentIter).second);
			++currentIter;
		}
	}
	answer.shrink_to_fit();
	return answer;

}

std::vector<std::set<uint16_t>> MeshLoader::nodeNeighbours()
{
	std::vector<std::set<uint16_t>> result(nodesCount + 1);
	std::for_each(this->finiteElements.begin(), this->finiteElements.end(), [&result](std::pair<const uint16_t, FiniteElement>& fe)
		{
			std::for_each(fe.second.nodes.begin(), fe.second.nodes.end(), [&fe, &result](uint16_t currID)
				{
					std::copy_if(fe.second.nodes.begin(), fe.second.nodes.end(), std::inserter(result.at(currID), result.at(currID).begin()), [&currID](uint16_t thisID)
						{
							return thisID != currID;
						});
				});
		});
	result.erase(result.begin());
    return result;
}

bool MeshLoader::insertMiddlesOfEdges()
{
	
	

	std::unordered_set<Edge, EdgeHash> container_edge;

	for (auto finiteElem : finiteElements)
	{
		std::vector<uint16_t> current_id_node = finiteElem.second.nodes; 

		for (auto i = current_id_node.begin(); i != current_id_node.end() - 1; i++)
		{
			for (auto j = i + 1; j != current_id_node.end(); j++)
			{
				Edge current_edge(*i, *j);

				std::unordered_set<Edge, EdgeHash>::iterator search_edge = container_edge.find(current_edge);
				std::vector<double> p_coord; 
				p_coord.push_back((nodes[*i].coords[0] + nodes[*j].coords[0]) / 2); 
				p_coord.push_back((nodes[*i].coords[1] + nodes[*j].coords[1]) / 2); 
				p_coord.push_back((nodes[*i].coords[2] + nodes[*j].coords[2]) / 2); 


				Node middle(nodes.size() + 1, p_coord);

				current_edge.middle_node = middle.ID; 

				if (search_edge == container_edge.end())
				{
					current_edge.self_id = nodes.size() + 1;

					container_edge.insert(current_edge);

					nodes.push_back(middle);

					finiteElem.second.nodes.push_back(middle.ID);

					auto pe_pe = finiteElements.find(finiteElem.first); 
					pe_pe->second.nodes.push_back(middle.ID);  

				

				}
				else
				{
					finiteElem.second.nodes.push_back(current_edge.last_id);
				}


			}

		}
	}

	for (auto &BFinElem : boundaryFiniteElements)
	{
		std::vector<uint16_t> current_id_node = BFinElem.second.nodes;
		for (std::vector<uint16_t>::iterator i = current_id_node.begin(); i != current_id_node.end() - 1; i++)
		{
			for (std::vector<uint16_t>::iterator j = i + 1; j != current_id_node.end(); j++)
			{
				std::unordered_set<Edge, EdgeHash>::iterator current_edge = container_edge.find(Edge(*i, *j));

				if (current_edge != container_edge.end())
				{
					BFinElem.second.nodes.push_back(current_edge->middle_node);
				}

			}
		}
	}

	
	

	
	
	
	
	/* 
	uint16_t id1;
	uint16_t id2;
	 auto currentIter = finiteElements.begin();
	auto endIter = finiteElements.end();
	 while (currentIter != endIter) {
		for (int i = 0; i < 4; i++) {
			for (int j = i + 1; j < 4; j++) {

				id1 = currentIter->second.nodes.at(i);
				id2 = currentIter->second.nodes.at(j);

				if (alreadyHasMiddle.find(std::make_pair(id1, id2)) == alreadyHasMiddle.end()) {
					//убрал две проверки
					    
					Node newNode;
					newNode.ID = nodesCount + 1;
					for (unsigned int k = 0; k < 3; k++)
					{
						newNode.coords.push_back((this->nodes.at(id1).coords.at(i) + this->nodes.at(id2).coords.at(k)) / 2);
					}
					nodes.push_back(newNode);
					nodesCount++;

                     //использован метод класса 
					if (boundaryEdges.find(std::make_pair(id1, id2)) != boundaryEdges.end())
					{
						//!!! Обновление граничных КЭ сделать в отдельном цикле, а не искать каждый раз ГКЭ для каждого ребра
						auto bfe = getBFEbyEdge(id1, id2);

						for (int i = 0; i < bfe.size(); i++) {
							bfe.at(i)->second.nodes.push_back(newNode.ID);
						}
					} 

					auto fe = getFEbyEdge(id1, id2); //!!! Вы для каждого КЭ обходите все КЭ. И того O(E*E) ...
					
					for (int i = 0; i < fe.size(); i++) {
						fe.at(i)->second.nodes.push_back(newNode.ID);
					}

					alreadyHasMiddle.insert(std::make_pair(id1, id2));
					alreadyHasMiddle.insert(std::make_pair(id2, id1));
				}
			}
		}

		currentIter++;
	} */ 

	

	
	/* //!!! Эта реализация крайне не эффектианая: Для каждого ребра вы обходите все граничные КЭ и простые. Итого O(edges_count * 2 * (fe_count + bfe_count))
	//!!! Обходить надо сразу КЭ и ГКЭ. Причем сначала одно, потом другое
	auto currentIter = allEdges.begin();
	auto endIter = allEdges.end();
	while (currentIter != endIter)
	{
		Node newNode;
		newNode.ID = nodesCount + 1;
		for (unsigned int k = 0; k < 3; k++)
		{
			newNode.coords.push_back((this->nodes.at(currentIter->first).coords.at(k) + this->nodes.at(currentIter->second).coords.at(k) / 2)); 
		}
		nodes.push_back(newNode);
		nodesCount++;

		auto bfe = getBFEbyEdge(currentIter->first, currentIter->second); 
		auto fe = getFEbyEdge(currentIter->first, currentIter->second);
		for (auto finElem : fe) //!!! Еще и копируем динамический массив на каждой итерации. Это просто верх тормознутости...
		{
			finElem->second.nodes.reserve(10);
			finElem->second.nodes.resize(10);
			find_pos_by_2_ids_and_FEdims(*currentIter, 4, finElem, newNode.ID);
		}
		for (auto BfinElem : bfe) //!!! Еще и копируем динамический массив на каждой итерации
		{
			BfinElem->second.nodes.reserve(6);
			BfinElem->second.nodes.resize(6);
			find_pos_by_2_ids_and_FEdims(*currentIter, 3, BfinElem, newNode.ID);
		}

		currentIter++; //!!! Еще и постфиксный икремент, который медленнее префиксного, чтобы тормозило посильнее.
	}
	std::cout << "Nodes have been succesfully inserted!" << std::endl;
	
	
	//!!! Порадовали прям... */
	return true;
}
