#pragma once

#include <stdint.h>
#include <vector>


struct Node {
	uint16_t ID;
	std::vector<double> coords;

	Node() {}

	Node(uint16_t p_ID, const std::vector<double> &p_coords) : ID(p_ID) { // p_const with const link 
		coords = std::move(p_coords);
	}
};

struct FiniteElement {
	uint16_t ID;
	uint16_t materialId;
	std::vector<uint16_t> nodes;

    //p_nodes with const link
	FiniteElement(uint16_t p_ID, uint16_t p_materialId, const std::vector<uint16_t> &p_nodes) : ID(p_ID), materialId(p_materialId) {
		nodes = std::move(p_nodes);
	}
	


	bool operator == (const FiniteElement& to_cmp) const
	{
		return to_cmp.ID == ID && to_cmp.materialId == materialId && to_cmp.nodes == nodes;
	}
};

struct BoundaryFiniteElement {
	uint16_t ID;
	uint16_t surfaceId;
	std::vector<uint16_t> nodes;

    //p_nodes with const link
	BoundaryFiniteElement(uint16_t p_ID, uint16_t p_surfaceId, const std::vector<uint16_t> &p_nodes) : ID(p_ID), surfaceId(p_surfaceId) {
		nodes = std::move(p_nodes);
	}

	std::vector<uint16_t> getNodes()
	{
		return nodes;
	}

	bool operator == (const BoundaryFiniteElement& to_cmp) const
	{
		return to_cmp.ID == ID && to_cmp.surfaceId == surfaceId && to_cmp.nodes == nodes;
	}
};

struct Edge
{
	uint16_t head_id;
	uint16_t last_id;
	uint16_t self_id;
	uint16_t middle_node; 
	Edge() = default;
	//Edge(uint16_t, uint16_t);

	bool operator == (const Edge& sec_odj) const
	{
		return (head_id == sec_odj.head_id && last_id == sec_odj.last_id) ||
			(last_id == sec_odj.head_id && head_id == sec_odj.last_id);

	}

	Edge(uint16_t h_if, uint16_t l_id): head_id(h_if),last_id(l_id){}

};

struct EdgeHash
{
	std::size_t operator() (const Edge& _p) const
	{
		std::size_t o_seed = 0;
		if (_p.head_id > _p.last_id)
		{
			o_seed ^= std::hash<int>() (_p.head_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
			o_seed ^= std::hash<int>() (_p.last_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
		}
		else
		{
			o_seed ^= std::hash<int>() (_p.last_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
			o_seed ^= std::hash<int>() (_p.head_id) + 0x9e3779b9 + (o_seed << 6) + (o_seed >> 2);
		}

		return o_seed;

	}
};