#pragma once

#include "Exceptions.h"
#include "MeshDatatypes.h"
#include <iostream>
#include <iomanip>
#include <algorithm>
#include <vector>
#include <unordered_map>

class MeshApplication
{
protected:
	void printMenu();
	void printFEanswer(std::vector<FiniteElement>::iterator begin, std::vector<FiniteElement>::iterator end); 
	void printFEanswerByIterators(std::vector<std::unordered_map<uint16_t, FiniteElement>::iterator>& answer);
	void printBoundaryFEanswer(std::vector<BoundaryFiniteElement>::iterator begin,  std::vector<BoundaryFiniteElement>::iterator end);
	void printNodesAnswer(std::vector<Node>::iterator begin, std::vector<Node>::iterator end);
public:
	MeshApplication();
	~MeshApplication();

	virtual void run() = 0;
};
