#include "MeshApplication.h"


MeshApplication::MeshApplication() {}

MeshApplication::~MeshApplication() {}

void MeshApplication::printMenu()
{
	std::cout << std::endl << "++++++++++++++++++++" << "  M E N U  " << "++++++++++++++++++++" << std::endl << std::endl;
	std::cout << "Please, press a key on your keyboard." << std::endl
		<< "1. Find finite element by 3 nodes' id's." << std::endl
		<< "2. Find finite element by an edge (2 nodes' id's)." << std::endl
		<< "3. Find finite element by material ID." << std::endl
		<< "4. Find nodes by surface ID." << std::endl
		<< "5. Find boundary finite elements by surface ID." << std::endl
		<< "6. Insert a new node in the middle of every edge." << std::endl
		<< "7. Show node's \"neighbours\"" << std::endl
		<< "8. Print all nodes." << std::endl
		<< "9. Print all finite elements." << std::endl
		<< "0. Print all boundary finite elements." << std::endl
		<< "p. Print everything." << std::endl
		<< "e. Exit." << std::endl << std::endl;
}



void MeshApplication::printFEanswer(std::vector<FiniteElement>::iterator begin, std::vector<FiniteElement>::iterator end)
{
	try {
		if (begin == end) {
			throw(new NoSuchDataExc("No such finite elements!"));
		}
		std::for_each(begin, end, [](FiniteElement& fe) {
			std::cout << fe.ID << ") ";
			std::cout.setf(std::ios::left);
			for (auto& n : fe.nodes) {
				std::cout << std::setw(4) << n;
			}
			std::cout << std::endl;
		});
	}
	catch (NoSuchDataExc ex) {
		std::cout << ex.what() << std::endl;
	}
	
}

void MeshApplication::printFEanswerByIterators(std::vector<std::unordered_map<uint16_t, FiniteElement>::iterator>& answer)
{
	try {
		if (answer.empty()) {
			throw(new NoSuchDataExc("No such finite elements!"));
		}

		std::for_each(answer.begin(), answer.end(), [](std::unordered_map<uint16_t, FiniteElement>::iterator& it) {
			std::cout << (*it).first <<") ";
			std::cout.setf(std::ios::left);
			std::for_each((*it).second.nodes.begin(), (*it).second.nodes.end(), [](const auto& node) {
				std::cout << std::setw(4) << node;
				}
			);
			std::cout << std::endl;
			}
		);
	}
	catch (NoSuchDataExc ex) {
		std::cout << ex.what() << std::endl;
	}
}

void MeshApplication::printNodesAnswer(std::vector<Node>::iterator begin, std::vector<Node>::iterator end)
{
	try {
		if (begin == end) {
			throw(new NoSuchDataExc("No such finite elements!"));
		}
		std::for_each(begin, end, [](const Node& node) {//!!! const
			std::cout << node.ID << ") ";
			std::cout.setf(std::ios::left);
			for (auto& n : node.coords) {
				std::cout << std::fixed;
				std::cout << std::setw(15) << n;
			}
			std::cout << std::endl;
			});
	}
	catch (NoSuchDataExc ex) {
		std::cout << ex.what() << std::endl;
	}
}

void MeshApplication::printBoundaryFEanswer(std::vector<BoundaryFiniteElement>::iterator begin,  std::vector<BoundaryFiniteElement>::iterator end)
{
	try {
		if (begin == end) {
			throw(new NoSuchDataExc("No such finite elements!"));
		}
		std::for_each(begin, end, [](const BoundaryFiniteElement& bfe) { // const
			std::cout << bfe.ID << ") ";
			std::cout.setf(std::ios::left);
			for (const auto& n : bfe.nodes) {             // const
				std::cout << std::setw(4) << n;
			}
			std::cout << std::endl;
			});
	}
	catch (NoSuchDataExc ex) {
		std::cout << ex.what() << std::endl;
	}
}