#include "AneuApplication.h"
#include <conio.h>

AneuApplication::AneuApplication() : MeshApplication() {}

AneuApplication::~AneuApplication() {}

void AneuApplication::run()
{
	AneuMeshLoader newLoader(fileName);
	try {
		newLoader.load();
	}
	catch (FileNotFoundExc exc) {
		std::wcout << exc.what() << std::endl;
	}
	
	char input = 'q';
	while (input != 'e') {
		printMenu();
		std::cout << "Please, input.........." << std::endl;
		input = _getche();
		std::cout << std::endl << std::endl;

		std::vector<Node> nodesAnswer;
		std::vector<FiniteElement> feAnswer;
		std::vector<std::unordered_map<uint16_t, FiniteElement>::iterator> feItAnswer;
		std::vector<BoundaryFiniteElement> bfeAnswer;
		std::vector<std::set<uint16_t>> neighboursAnswer;

		uint16_t id1, id2, id3;
		uint16_t materialID;
		uint16_t surID;
		int counter = 1;

		switch (input) {
		case '1':
			std::cout << "Input nodes' ID's:" << std::endl;
			std::cin >> id1;
			std::cin >> id2;
			std::cin >> id3;

			feAnswer = newLoader.getFEbyNodesIds(id1, id2, id3);
			printFEanswer(feAnswer.begin(), feAnswer.end());
			break;

		case '2':
			std::cout << "Input edge's nodes' ID's:" << std::endl;
			std::cin >> id1;
			std::cin >> id2;
			feItAnswer = newLoader.getFEbyEdge(id1, id2);
			printFEanswerByIterators(feItAnswer);
			break;

		case '3':
			std::cout << "Input material ID:" << std::endl;
			std::cin >> materialID;
			feAnswer = newLoader.getFEbyMaterialID(materialID);
			printFEanswer(feAnswer.begin(), feAnswer.end());
			break;

		case '4':
			std::cout << "Input surface ID:" << std::endl;
			std::cin >> surID;
			nodesAnswer = newLoader.getNodesbySurfaceID(surID);
			printNodesAnswer(nodesAnswer.begin(), nodesAnswer.end());
			break;

		case '5':
			std::cout << "Input surface ID:" << std::endl;
			std::cin >> surID;
			bfeAnswer = newLoader.getBFEbySurfaceID(surID);
			printBoundaryFEanswer(bfeAnswer.begin(), bfeAnswer.end());
			break;

		case '6':
			newLoader.insertMiddlesOfEdges();
			break;

		case '7':
			neighboursAnswer = newLoader.nodeNeighbours();
			std::for_each(neighboursAnswer.begin(), neighboursAnswer.end(), [&counter](const std::set<uint16_t>& curr)
				{
					std::cout << "Node's with id " << counter << " neighbours:   ";
					std::for_each(curr.begin(), curr.end(), [](uint16_t currID)
						{
							std::cout << currID << " ";
						});
					std::cout << std::endl;
					counter++;
				});
			break;

		case '8':
			newLoader.printNodes();
			break;

		case '9':
			newLoader.printFiniteElems();
			break;

		case '0':
			newLoader.printBoundaryFiniteElements();
			break;

		case 'p':
			std::cout << std::endl << "NODES:" << std::endl;
			newLoader.printNodes();
			std::cout << std::endl << "FINITE ELEMENTS:" << std::endl;
			newLoader.printFiniteElems();
			std::cout << std::endl << "BOUNDARY FINITE ELEMENTS:" << std::endl;
			newLoader.printBoundaryFiniteElements();
			break;

		case 'e':
			std::cout << std::endl << std::endl << "Thanks for using this app!" << std::endl << std::endl;
			break;
		}
	}
}
