#include "mainwindow.h"
#include "ui_mainwindow.h"


size_t MainWindow::newFileName = 0;

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ui->newAct->setIcon(QPixmap(":/toolBar/images/new.jpg"));
    ui->openAct->setIcon(QPixmap(":/toolBar/images/open.jpg"));
     ui->saveAct->setIcon(QPixmap(":/toolBar/images/save.png"));
      ui->saveAllAct->setIcon(QPixmap(":/toolBar/images/saveAll.png"));


   fileSystem.setRootPath("C:\\");

   ui->treeView->setModel(&fileSystem);

   ui->fileTreeDock->setWidget(ui->treeView);

   ui->fileTreeDock->setFeatures(QDockWidget::DockWidgetClosable | QDockWidget::DockWidgetMovable);

   ui->fileTreeDock->setWindowTitle("Проводник");


   ui->listView->setModel(&strList);

   ui->activeFilesDock->setWidget(ui->listView);

   ui->activeFilesDock->setFeatures(QDockWidget::DockWidgetClosable | QDockWidget::DockWidgetMovable);

   ui->activeFilesDock->setWindowTitle("Обозреватель открытых документов");

   this->setWindowTitle("Текстовый редактор");


   connect(ui->fileTreeAct,SIGNAL(toggled(bool)),this, SLOT(on_fileTreeAct(bool)));

   connect(ui->activeFilesAct,SIGNAL(toggled(bool)),this, SLOT(on_activeFilesAct(bool)));

   bar = new QToolBar();

  bar->addAction(ui->newAct);
  bar->addAction(ui->openAct);
  bar->addAction(ui->saveAct);
   bar->addAction(ui->saveAllAct);

   addToolBar(Qt::TopToolBarArea,bar);


};

MainWindow::~MainWindow()
{
    delete ui;
}


void MainWindow::on_newAct_triggered()
{

    QString countTabsStr ;
    countTabsStr.setNum( ++newFileName );
    QString nameFile = "Новый документ"+ countTabsStr +".txt";
    fileNames.push_back(nameFile);
    strList.setStringList(fileNames);
    fileDirs.push_back(QDir::current());
    QPlainTextEdit* textEd = new QPlainTextEdit();
    ui->tabWidget->addTab(textEd,nameFile);
    if(ui->tabWidget->currentIndex() == -1)
    {
        ui->tabWidget->setCurrentIndex(0);
    }
    else {
     ui->tabWidget->setCurrentIndex(ui->tabWidget->count() - 1 );
    }



}

void MainWindow::on_closeAct_triggered()
{
    QMessageBox msgBox;
    msgBox.setText("Хотите сохранить изменения в файле "+ui->tabWidget->tabText(ui->tabWidget->currentIndex())+ " ?");
    QPushButton *saveButton = msgBox.addButton(tr("Сохранить"), QMessageBox::ActionRole);
    QPushButton *closeButton = msgBox.addButton(tr("Закрыть"),QMessageBox::ActionRole);
    QPushButton *cancelButton = msgBox.addButton(tr("Отменить"),QMessageBox::ActionRole);


    msgBox.exec();

    if(msgBox.clickedButton() == cancelButton)
    {
     return;
    }

    else {

        for(auto i = 0 ; i < fileNames.count() ; i++)
       {

           if(fileNames.at(i) == ui->tabWidget->tabText(ui->tabWidget->currentIndex()) )
            {
           fileNames.removeAt(i);
           fileDirs.removeAt(i);
           break;
            }

        }

       strList.setStringList(fileNames);

        if (msgBox.clickedButton() == saveButton)
        {
        on_saveAct_triggered();
         ui->tabWidget->removeTab(ui->tabWidget->currentIndex());
         }

         else if(msgBox.clickedButton() == closeButton)
         {
         ui->tabWidget->removeTab(ui->tabWidget->currentIndex());
         }

    }


}

void MainWindow::on_closeAllAct_triggered()
{

    int count = ui->tabWidget->count();
    for(int index = 0 ; index < count ; index++)
      {
          ui->tabWidget->setCurrentIndex(0);
          on_closeAct_triggered();
     }
}

void MainWindow::on_exitAct_triggered()
{
    Dialog* dial = new Dialog;

    dial->setWindowTitle("Хотите сохранить файлы перед выход ?");

    dial->fillTable(fileDirs,fileNames);

     int mode = dial->exec();

    if(mode == QDialog::Accepted)
    {
        on_saveAllAct_triggered();
         qApp->quit();
    }
    if(mode == QDialog::Rejected)
    {
        qApp->quit();
    }

}

void MainWindow::on_openAct_triggered()
{


 QString openFileName = QFileDialog::getOpenFileName(this,"Выбрать файл для открытия","C:\\",
                                                     "Все файлы (*.txt *.h *.cpp *.pro *.pdf) ;; "
                                                     "C++ файлы (*.h *.cpp *.pro);; Текстовые .txt ;; PDF файлы *.pdf");

 QFile file(openFileName);
 QTextStream text (&file);
 QString str;


 if(file.open(QIODevice::ReadOnly))
 {

  while(!text.atEnd())
  {
      str += text.readLine();
      str +="\n";
  }

 }
 else
 {

   QErrorMessage * msg = new QErrorMessage();
   msg->showMessage("Файл с данным расширением не открывается");
      return;

 }

 QPlainTextEdit* textEd = new QPlainTextEdit;


 textEd->setPlainText(str);


 QFileInfo fileInfo (file);

 if(fileInfo.completeSuffix() == "h" || fileInfo.completeSuffix() == "cpp" || fileInfo.completeSuffix() == "pro" || fileInfo.completeSuffix() == "ui" )
 {
       highLighter  = new Highlighter (textEd->document());
 }


 ui->tabWidget->addTab(textEd,fileInfo.baseName() + "." + fileInfo.completeSuffix());

  fileNames.push_back(QString (fileInfo.baseName() + "." + fileInfo.completeSuffix()) );

  fileDirs.push_back(fileInfo.path());

  strList.setStringList(fileNames);

  ui->tabWidget->setCurrentIndex(ui->tabWidget->count() - 1 );

 file.close();
}



void MainWindow::on_saveAct_triggered()
{

    QPlainTextEdit* textEd =  qobject_cast<QPlainTextEdit*> (ui->tabWidget->currentWidget());
   if( textEd==nullptr )
    {
       QErrorMessage * msg = new QErrorMessage();
       msg->showMessage("Ошибка сохранения файла");
          return;

    }

    QFile file(ui->tabWidget->tabText(ui->tabWidget->currentIndex()));
    QTextStream text(&file);
    if(file.open(QIODevice::WriteOnly  ))
    {
       text<<textEd->toPlainText();
    }
    else
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Ошибка сохранения файла");
        return;
    }

    file.close();
}

void MainWindow::on_saveAsAct_triggered()
{
    QString saveFileName = QFileDialog::getSaveFileName(this,"Выбрать файл для сохранения","C:\\",
                                                        "Все файлы (*.txt *.cpp *.h);; Текстовый файлы *.txt ;;"
                                                        " C++ файлы (*.h *.cpp)");

    QPlainTextEdit* textEd =  qobject_cast<QPlainTextEdit*> (ui->tabWidget->currentWidget());
   if( textEd==nullptr )
    {
       QErrorMessage * msg = new QErrorMessage();
       msg->showMessage("Ошибка сохранения файла");
          return;
    }

    QFile file(saveFileName);
    QTextStream text(&file);
    if(file.open(QIODevice::WriteOnly))
    {
       text<<textEd->toPlainText();
    }
    else
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Ошибка сохранения файла");
        return;

    }


    file.close();
}

void MainWindow::on_saveAllAct_triggered()
{
    int prev_index = ui->tabWidget->currentIndex();
    int count = ui->tabWidget->count();
    for( int index = 0 ; index < count; index++)
    {
        ui->tabWidget->setCurrentIndex(index);
        on_saveAct_triggered();
    }

    ui->tabWidget->setCurrentIndex(prev_index);

}


void MainWindow::on_fileTreeDock_visibilityChanged(bool visible)
{
    ui->fileTreeAct->setChecked(visible);
}

void MainWindow::on_activeFilesDock_visibilityChanged(bool visible)
{
    ui->activeFilesAct->setChecked(visible);
}

void MainWindow::on_listView_clicked(const QModelIndex &index)
{
    if(!index.isValid())
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Возникла ошибка в обозревателе открытых документов");
        return;
    }
    ui->tabWidget->setCurrentIndex(index.row());
}

void MainWindow::on_fileTreeAct(bool visible)
{

    if(visible)
    {
        ui->fileTreeDock->show();
    }
    else
    {
      ui->fileTreeDock->close();
    }
}
void MainWindow::on_activeFilesAct(bool visible)
{
    if(visible)
    {
        ui->activeFilesDock->show();
    }
    else
    {
        ui->activeFilesDock->close();
    }
}



void MainWindow::on_cutAct_triggered()
{
    QPlainTextEdit* textEd =  qobject_cast<QPlainTextEdit*> (ui->tabWidget->currentWidget());
    if(textEd == nullptr)
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Ошибка вырезки");
        return;
    }

    textEd->cut();
}

void MainWindow::on_copyAct_triggered()
{
    QPlainTextEdit* textEd =  qobject_cast<QPlainTextEdit*> (ui->tabWidget->currentWidget());
    if(textEd == nullptr)
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Ошибка копирования");
        return;
    }

    textEd->copy();
}

void MainWindow::on_insertAct_triggered()
{
    QPlainTextEdit* textEd =  qobject_cast<QPlainTextEdit*> (ui->tabWidget->currentWidget());
    if(textEd == nullptr)
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Ошибка вставки");
        return; //
    }

    textEd->paste();
}

void MainWindow::on_deleteAct_triggered()
{
    QPlainTextEdit* textEd =  qobject_cast<QPlainTextEdit*> (ui->tabWidget->currentWidget());
    if(textEd == nullptr)
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Ошибка удаления");
        return; //
    }

    textEd->textCursor().removeSelectedText();
}

void MainWindow::on_highlightAct_triggered()
{
    QPlainTextEdit* textEd =  qobject_cast<QPlainTextEdit*> (ui->tabWidget->currentWidget());
    if(textEd == nullptr)
    {
        QErrorMessage * msg = new QErrorMessage();
        msg->showMessage("Ошибка выделить все");
        return; //
    }

    textEd->selectAll();
}

void MainWindow::on_treeView_clicked(const QModelIndex &index)
{
    if(!index.isValid())
    {
        QErrorMessage* msg = new QErrorMessage;
        msg->showMessage("Oшибка открытия файла");
    }
   QString path = fileSystem.filePath(index);
   if(path.contains('.'))
   {

       QFile file(path);
       QTextStream text (&file);
       QString str;

       if(file.open(QIODevice::ReadOnly))
       {
        while(!text.atEnd())
        {
            str += text.readLine();
            str +="\n";
        }
       }
       else
       {
         QErrorMessage * msg = new QErrorMessage();
         msg->showMessage("Файл с данным расширением не открывается");
            return;
       }

        QPlainTextEdit* textEd = new QPlainTextEdit;

        textEd->setPlainText(str);


        QFileInfo fileInfo (file);

        if(fileInfo.completeSuffix() == "h" || fileInfo.completeSuffix() == "cpp" || fileInfo.completeSuffix() == "pro" || fileInfo.completeSuffix() == "ui" )
        {
              highLighter  = new Highlighter (textEd->document());
        }


        ui->tabWidget->addTab(textEd,fileInfo.baseName() + "." + fileInfo.completeSuffix());

        fileNames.push_back(QString (fileInfo.baseName() + "." + fileInfo.completeSuffix()) );

        fileDirs.push_back(fileInfo.path());

        strList.setStringList(fileNames);

        ui->tabWidget->setCurrentIndex(ui->tabWidget->count() - 1 );

       file.close();
   }
   else
   {
       return;
       // кликнул на папку , выходишь
   }
}


