#ifndef CALCULATOR_H
#define CALCULATOR_H

#include <QWidget>
#include <QLineEdit>
#include <QGridLayout>
#include <QRadioButton>
#include <QPushButton>
#include <cmath>
#include <QLabel>

class Calculator : public QWidget
{
    Q_OBJECT
public:
    explicit Calculator(QWidget *parent = nullptr);

private slots:
    void number_clicked();
    void unary_operation_clicked();
    void first_order_operation_clicked();
    void second_order_operation_clicked();
    void sign_button_clicked();
    void answer_button_clicked();
    void dot_clicked();
    void erase_button_clicked();
    void clear_button_clicked();
    void clear_all_button_clicked();
    void clear_memory_button_clicked();
    void read_memory_button_clicked();
    void write_memory_button_clicked();
    void add_to_memory_button_blicked();
    void erase_from_memory_button_clicked();

    void eng_unary_operation_clicked();
    void power_operation_clicked();
    void mode_toggled();

private:
    QPushButton *make_button (const QString &text, const char* member);
    void display_error();
    bool calculate (double rightOperand, const QString& pendingOperator);

    double stored_sum;
    double current_sum;
    double current_factor;
    QString unfinished_first_order_operation;
    QString unfinished_second_order_operation;
    bool input_unfinished;

    QLineEdit* display;

    QPushButton* number_buttons[10];

    QString unfinished_hp_operation;
    void hp_operation();
    double hp_result = 0.0;

    QGridLayout* main_layout;

    QGridLayout* standart_layout;
    QWidget* standard_widget;

    QPushButton* dot_button;
    QPushButton* sign_button;

    QPushButton* erase_button;
    QPushButton* clear_button;
    QPushButton* clear_all_button;

    QPushButton* clear_memory_button;
    QPushButton* read_memory_button;
    QPushButton* write_memory_button;
    QPushButton* add_to_memory_button;
    QPushButton* erase_from_memory_button;

    QPushButton* division_button;
    QPushButton* multiplication_button;
    QPushButton* subtraction_button;
    QPushButton* addition_button;

    QPushButton* sqrt_button;
    QPushButton* rdivision_button;
    QPushButton* answer_button;

    QGridLayout* engineering_layout;
    QWidget* engineering_widget;

    QPushButton* pi_button;

    QPushButton* square_button;
    QPushButton* cube_button;
    QPushButton* power_button;

    QPushButton* cbrt_button;
    QPushButton* root_button;

    QPushButton* factorial_button;

    QPushButton* sinh_button;
    QPushButton* cosh_button;
    QPushButton* tanh_button;
    QPushButton* sin_button;
    QPushButton* cos_button;
    QPushButton* tan_button;

    QPushButton* exp_button;
    QPushButton* ln_button;
    QPushButton* log_button;

    QGridLayout* default_layout;
    QWidget* default_widget;

    QLabel* mode_label;
    QRadioButton* standart_rbutton;
    QRadioButton* engineering_rbutton;

    void set_standart_mode();
    void set_engineering_mode();
};

#endif // CALCULATOR_H
