#include "calculator.h"

Calculator::Calculator(QWidget *parent)
    : QWidget(parent)
    , stored_sum(0.0), current_sum(0.0)
    , current_factor (0.0), input_unfinished(true)
{
    setWindowFlags(Qt::Widget | Qt::MSWindowsFixedSizeDialogHint);
    display = new QLineEdit("0", this);
    display->setStyleSheet("QLineEdit {color: white}");
    display->setReadOnly(true);
    display->setAlignment(Qt::AlignRight);
    display->setMaxLength(15);

    QFont font = display->font();
    font.setPointSize(font.pointSize() + 8);
    display->setFont(font);

    for (int i = 0; i < 10; ++i)
        number_buttons[i]=make_button(QString::number(i), SLOT(number_clicked()));

    dot_button               = make_button("."       , SLOT(dot_clicked()                     ));
    sign_button              = make_button("\302\261", SLOT(sign_button_clicked()             ));
    erase_button             = make_button("DEL"     , SLOT(erase_button_clicked()            ));
    clear_button             = make_button("C"       , SLOT(clear_button_clicked()            ));
    clear_all_button         = make_button("AC"      , SLOT(clear_all_button_clicked()        ));
    clear_memory_button      = make_button("MC"      , SLOT(clear_memory_button_clicked()     ));
    read_memory_button       = make_button("MR"      , SLOT(read_memory_button_clicked()      ));
    write_memory_button      = make_button("MS"      , SLOT(write_memory_button_clicked()     ));
    add_to_memory_button     = make_button("M+"      , SLOT(add_to_memory_button_blicked()    ));
    erase_from_memory_button = make_button("M-"      , SLOT(erase_from_memory_button_clicked()));
    answer_button            = make_button("="       , SLOT(answer_button_clicked()           ));

    division_button       = make_button("\303\267", SLOT(second_order_operation_clicked()));
    multiplication_button = make_button("\303\227", SLOT(second_order_operation_clicked()));

    subtraction_button = make_button("-", SLOT(first_order_operation_clicked()));
    addition_button    = make_button("+", SLOT(first_order_operation_clicked()));

    sqrt_button      = make_button("\342\210\232", SLOT(unary_operation_clicked()));
    rdivision_button = make_button("1/x"         , SLOT(unary_operation_clicked()));


    power_button = make_button("x\312\270"           , SLOT(power_operation_clicked()));
    root_button  = make_button("\312\270\342\210\232", SLOT(power_operation_clicked()));

    square_button    = make_button("x\302\262"   , SLOT(eng_unary_operation_clicked()));
    cube_button      = make_button("x\302\263"   , SLOT(eng_unary_operation_clicked()));
    sinh_button      = make_button("sinh"        , SLOT(eng_unary_operation_clicked()));
    cosh_button      = make_button("cosh"        , SLOT(eng_unary_operation_clicked()));
    tanh_button      = make_button("tanh"        , SLOT(eng_unary_operation_clicked()));
    sin_button       = make_button("sin"         , SLOT(eng_unary_operation_clicked()));
    cos_button       = make_button("cos"         , SLOT(eng_unary_operation_clicked()));
    tan_button       = make_button("tan"         , SLOT(eng_unary_operation_clicked()));
    exp_button       = make_button("exp"         , SLOT(eng_unary_operation_clicked()));
    ln_button        = make_button("ln"          , SLOT(eng_unary_operation_clicked()));
    log_button       = make_button("log"         , SLOT(eng_unary_operation_clicked()));
    factorial_button = make_button("n\41"        , SLOT(eng_unary_operation_clicked()));
    pi_button        = make_button("\317\200"    , SLOT(eng_unary_operation_clicked()));
    cbrt_button      = make_button("\342\210\233", SLOT(eng_unary_operation_clicked()));

    standard_widget = new QWidget(this);
    standart_layout = new QGridLayout(this);

    standart_layout->addWidget(clear_memory_button     , 2, 0);
    standart_layout->addWidget(read_memory_button      , 3, 0);
    standart_layout->addWidget(write_memory_button     , 4, 0);
    standart_layout->addWidget(add_to_memory_button    , 5, 0);
    standart_layout->addWidget(erase_from_memory_button, 5, 1);

    for (int i = 1; i < 10; ++i)
        standart_layout->addWidget(number_buttons[i], (9 - i) / 3 + 2, (i - 1) % 3 + 1);

    standart_layout->addWidget(number_buttons[0], 5, 2, 1, 1);

    standart_layout->addWidget(dot_button , 5, 3);
    standart_layout->addWidget(sign_button, 4, 5);

    standart_layout->addWidget(division_button      , 2, 4);
    standart_layout->addWidget(multiplication_button, 3, 4);
    standart_layout->addWidget(subtraction_button   , 4, 4);
    standart_layout->addWidget(addition_button      , 5, 4);

    standart_layout->addWidget(sqrt_button     , 2, 5);
    standart_layout->addWidget(rdivision_button, 3, 5);
    standart_layout->addWidget(answer_button   , 5, 5);

    standard_widget->setLayout(standart_layout);

    engineering_widget = new QWidget(this);
    engineering_layout = new QGridLayout(this);

    engineering_layout->addWidget(square_button, 2, 3);
    engineering_layout->addWidget(cube_button  , 3, 3);
    engineering_layout->addWidget(power_button , 4, 3);

    engineering_layout->addWidget(sinh_button, 2, 0);
    engineering_layout->addWidget(cosh_button, 3, 0);
    engineering_layout->addWidget(tanh_button, 4, 0);
    engineering_layout->addWidget(sin_button , 2, 1);
    engineering_layout->addWidget(cos_button , 3, 1);
    engineering_layout->addWidget(tan_button , 4, 1);
    engineering_layout->addWidget(exp_button , 2, 2);
    engineering_layout->addWidget(ln_button  , 3, 2);
    engineering_layout->addWidget(log_button , 4, 2);

    engineering_layout->addWidget(factorial_button, 5, 0);
    engineering_layout->addWidget(pi_button       , 5, 1);
    engineering_layout->addWidget(cbrt_button     , 5, 2);
    engineering_layout->addWidget(root_button     , 5, 3);

    engineering_widget->setLayout(engineering_layout);

    standart_rbutton    = new QRadioButton("Stantart"   , this); //!!! Строки, которые отображаются в интерфейсе, желательно помещать в tr("...")
    engineering_rbutton = new QRadioButton("Engineering", this); //!!! Строки, которые отображаются в интерфейсе, желательно помещать в tr("...")
    mode_label          = new QLabel      ("Mode:"); //!!! Строки, которые отображаются в интерфейсе, желательно помещать в tr("...")

    //!!! Код не должен быть шире 100 символов
    
    standart_rbutton   ->setStyleSheet("QRadioButton{width: 0px; height: 15px; color: white;}"
                                       "QRadioButton::indicator::unchecked{ border: 1px solid darkgray; border-radius: 6px; background-color: white; width: 10px; height: 10px; margin-left: 1px;}"
                                       "QRadioButton::indicator::checked{ border: 1px solid darkgray; border-radius: 6px; background-color: darkblue; width: 10px; height: 10px; margin-left: 1px;}");
    engineering_rbutton->setStyleSheet("QRadioButton{width: 0px; height: 15px; color: white;}"
                                       "QRadioButton::indicator::unchecked{ border: 1px solid darkgray; border-radius: 6px; background-color: white; width: 10px; height: 10px; margin-left: 1px;}"
                                       "QRadioButton::indicator::checked{ border: 1px solid darkgray; border-radius: 6px; background-color: darkblue; width: 10px; height: 10px; margin-left: 1px;}");

    mode_label->setStyleSheet("QLabel{color: white};");

    this->setStyleSheet("QWidget{background-color:black;}");

    standart_rbutton->setChecked(true);
    QVBoxLayout* switch_mode_layout = new QVBoxLayout(this);

    switch_mode_layout->setSpacing(4);
    switch_mode_layout->setAlignment(Qt::AlignTop);

    switch_mode_layout->addWidget(mode_label);
    switch_mode_layout->addWidget(standart_rbutton);
    switch_mode_layout->addWidget(engineering_rbutton);

    QWidget* checkedBox = new QWidget(this);
    checkedBox->setLayout(switch_mode_layout);

    default_layout = new QGridLayout(this);
    default_widget = new QWidget(this);

    default_layout->addWidget(display         , 0, 0, 1, 6);
    default_layout->addWidget(clear_button    , 1, 3      );
    default_layout->addWidget(clear_all_button, 1, 4      );
    default_layout->addWidget(erase_button    , 1, 5      );
    default_layout->addWidget(checkedBox      , 1, 0, 1, 3);

    default_widget->setLayout(default_layout);
    connect(standart_rbutton, SIGNAL(toggled(bool)), this, SLOT(mode_toggled()));

    set_standart_mode();
}

void Calculator::set_standart_mode(){
    main_layout = new QGridLayout(this);
    engineering_widget->hide();
    main_layout->addWidget(default_widget , 0, 0, 1, 3);
    main_layout->addWidget(standard_widget, 1, 0, 1, 3);

    setLayout(main_layout);
    setWindowTitle("Standard Calculator"); //!!! Строки, которые отображаются в интерфейсе, желательно помещать в tr("...")
}

void Calculator::set_engineering_mode(){
    main_layout = new QGridLayout(this);
    main_layout->addWidget(default_widget , 0, 0, 1, 9);
    main_layout->addWidget(engineering_widget    , 1, 0, 1, 4);
    main_layout->addWidget(standard_widget, 1, 4, 1, 5);
    engineering_widget->show();

    setLayout(main_layout);
    setWindowTitle("Engineering Calculator"); //!!! Строки, которые отображаются в интерфейсе, желательно помещать в tr("...")
}

void Calculator::mode_toggled(){
    if(!standart_rbutton->isChecked()){
        delete main_layout;
        setMinimumSize(550, 350);
        setMaximumSize(550, 350);
        set_engineering_mode();
    }
    else{
        delete main_layout;
        setMinimumSize(350, 350);
        setMaximumSize(350, 350);
        set_standart_mode();
    }
}

void Calculator::number_clicked(){
    QPushButton* clicked_button = qobject_cast<QPushButton*>(sender());  //!!! Где проверка правильности приведения?
    int number_value = clicked_button->text().toInt();
    if (display->text() == "0" && number_value == 0.0)
        return;

    if (input_unfinished) {
        display->clear();
        input_unfinished = false;
    }

    display->setText(display->text() + QString::number(number_value));
}

void Calculator::unary_operation_clicked(){
    QPushButton* clicked_button = qobject_cast<QPushButton*>(sender());  //!!! Где проверка правильности приведения?
    QString clicked_operation = clicked_button->text();

    double operand = display->text().toDouble();
    double result = 0.0;

    if (clicked_operation == "\342\210\232"){
        if (operand < 0.0){
            display_error();
            return;
        }
        result = std::sqrt(operand);
    }

    else if (clicked_operation == "1/x"){
        if (operand == 0){
            display_error();
            return;
        }
        result = 1.0 / operand;
    }

    display->setText(QString::number(result));
    input_unfinished = true;
}

void Calculator::first_order_operation_clicked() {
    QPushButton* clicked_button = qobject_cast<QPushButton*>(sender()); 
    if (!clicked_button)
        return;
    QString clicked_operation = clicked_button->text();
    double operand = display->text().toDouble();

    if (!unfinished_hp_operation.isEmpty()) {
        hp_operation();
        display->setText(QString::number(hp_result));
        operand = hp_result;
        hp_result = 0.0;
        unfinished_hp_operation.clear();
    }

    if (!unfinished_second_order_operation.isEmpty()){
        if (!calculate(operand, unfinished_second_order_operation)) {
            display_error();
            return;
        }
        display->setText(QString::number(current_factor));
        operand = current_factor;
        current_factor = 0.0;
        unfinished_second_order_operation.clear();
    }

    if (!unfinished_first_order_operation.isEmpty()){
        if(!calculate(operand, unfinished_first_order_operation)){
            display_error();
            return;
        }
        display->setText(QString::number(current_sum));
    }
    else {
        current_sum = operand;
    }
    unfinished_first_order_operation = clicked_operation;
    input_unfinished = true;
}

void Calculator::second_order_operation_clicked(){
    QPushButton* clicked_button = qobject_cast<QPushButton*>(sender());
    if (!clicked_button)
        return;

    QString clicked_operation = clicked_button->text();
    double operand = display->text().toDouble();

    if (!unfinished_hp_operation.isEmpty()) {
        hp_operation();
        display->setText(QString::number(hp_result));
        operand = hp_result;
        hp_result = 0.0;
        unfinished_hp_operation.clear();
    }

    if (!unfinished_second_order_operation.isEmpty()){
        if (!calculate(operand, unfinished_second_order_operation)){
            display_error();
            return;
        }
        display->setText(QString::number(current_factor));
    }
    else{
        current_factor = operand;
    }

    unfinished_second_order_operation = clicked_operation;
    input_unfinished = true;
}

void Calculator::answer_button_clicked(){
    double operand = display->text().toDouble();

    if (!unfinished_hp_operation.isEmpty()) {
        hp_operation();
        display->setText(QString::number(hp_result));
        operand = hp_result;
        hp_result = 0.0;
        unfinished_hp_operation.clear();
    }

    if(!unfinished_second_order_operation.isEmpty()){
        if (!calculate(operand, unfinished_second_order_operation)){
            display_error();
            return;
        }
        operand = current_factor;
        current_factor = 0.0;
        unfinished_second_order_operation.clear();
    }

    if (!unfinished_first_order_operation.isEmpty()){
        if (!calculate(operand, unfinished_first_order_operation)){
            display_error();
            return;
        }
        unfinished_first_order_operation.clear();
    }
    else {
        current_sum = operand;
    }

    display->setText(QString::number(current_sum));
    current_sum = 0.0;
    input_unfinished = true;
}

void Calculator::dot_clicked(){
    if (input_unfinished)
        display->setText("0");
    if (!display->text().contains('.'))
        display->setText(display->text() + ".");
    input_unfinished = false;
}

void Calculator::sign_button_clicked(){
    QString text = display->text();
    double value = text.toDouble();

    if (value > 0.0)
        text.prepend("-");
    else if (value < 0.0)
        text.remove(0, 1);
    display->setText(text);
}

void Calculator::erase_button_clicked(){
    if (input_unfinished)
        return;

    QString text = display->text();
    text.chop(1);
    if (text.isEmpty()){
        text = "0";
        input_unfinished = true;
    }
    display->setText(text);
}

void Calculator::clear_button_clicked(){
    if (input_unfinished)
        return;
    display->setText("0");
    input_unfinished = true;
}

void Calculator::clear_all_button_clicked(){
    current_sum = 0.0;
    current_factor = 0.0;
    unfinished_first_order_operation.clear();
    unfinished_second_order_operation.clear();
    display->setText("0");
    input_unfinished = true;
}

void Calculator::clear_memory_button_clicked(){
    stored_sum = 0.0;
}

void Calculator::read_memory_button_clicked(){
    display->setText(QString::number(stored_sum));
    input_unfinished = true;
}

void Calculator::write_memory_button_clicked(){
    answer_button_clicked();
    stored_sum = display->text().toDouble();
}

void Calculator::add_to_memory_button_blicked(){
    answer_button_clicked();
    stored_sum += display->text().toDouble();
}

void Calculator::erase_from_memory_button_clicked(){
    answer_button_clicked();
    stored_sum -= display->text().toDouble();
}

QPushButton* Calculator::make_button(const QString &text, const char *member){
    QPushButton* button = new QPushButton(text, this);
    connect (button, SIGNAL(clicked()), this, member);
    button->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);
    button->setFixedSize(QSize(40, 40));
    button->setStyleSheet("QPushButton{color: white;}");
    return button;
}

void Calculator::display_error(){
    clear_all_button_clicked();
    display->setText("Error");
}

bool Calculator::calculate(double right_operand, const QString &operation){
    if (operation == "+"){
        current_sum += right_operand;
    }
    else if (operation == "-"){
        current_sum -= right_operand;
    }
    else if (operation == "\303\227"){
        current_factor *= right_operand;
    }
    else if (operation == "\303\267"){
        if (right_operand == 0.0)
            return false;
        current_factor /= right_operand;
    }
    return true;
}

double factorial (int n){
    if (n <= 0)
        return 1;
    return n * factorial (n - 1);
}

void Calculator::eng_unary_operation_clicked(){
    QPushButton* clicked_button = qobject_cast<QPushButton*>(sender()); //!!! Где проверка правильности приведения?
    QString clicked_operation = clicked_button->text();

    double operand = display->text().toDouble();
    double result = 0.0;

    if (clicked_operation == "sinh")
        result = std::sinh(operand);

    else if (clicked_operation == "cosh")
        result = std::cosh(operand);

    else if (clicked_operation == "tanh")
        result = std::tanh(operand);

    else if (clicked_operation == "sin")
        result = std::sin(operand);

    else if (clicked_operation == "cos")
        result = std::cos(operand);

    else if (clicked_operation == "tan")
        result = std::tan(operand);

    else if (clicked_operation == "exp")
        result = std::exp(operand);

    else if (clicked_operation == "ln")
        result = std::log(operand);

    else if (clicked_operation == "log")
        result = std::log2(operand);

    else if (clicked_operation == "x\302\262")
        result = std::pow(operand, 2);

    else if (clicked_operation == "x\302\263")
        result = std::pow(operand, 3);

    else if (clicked_operation == "\317\200")
        result = 3.1415926535897;

    else if (clicked_operation == "n\41"){
        if (operand < 0 || display->text().contains('.')){
            display_error();
            return;
        }
        result = factorial(operand);
    }
    else if (clicked_operation == "\342\210\233")
        result = std::pow(operand, 1.0 / 3.0);

    display->setText(QString::number(result));
    input_unfinished = true;
}

void Calculator::hp_operation() {
    if (!unfinished_hp_operation.isEmpty())
        power_operation_clicked();
}

void Calculator::power_operation_clicked(){
    QPushButton* clicked_button = qobject_cast<QPushButton*>(sender());
    if (!clicked_button)
        return;

    QString clicked_operation = clicked_button->text();
    double operand = display->text().toDouble();

    if (!unfinished_hp_operation.isEmpty()) {
        if (unfinished_hp_operation == "x\312\270") {
            hp_result = std::pow(hp_result, operand);
        }
        if (unfinished_hp_operation == "\312\270\342\210\232") {
            if (operand == 0) {
                display_error();
                return;
            }
            hp_result = std::pow(operand, 1 / hp_result);
        }
        display->setText(QString::number(hp_result));
    }
    else {
        hp_result = operand;
    }
    unfinished_hp_operation = clicked_operation;
    input_unfinished = true;
}
